/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.VWUDDIBrowseTreeCellRenderer;
import filenet.vw.toolkit.utils.ws.VWUDDIBusinessDetailsPanel;
import filenet.vw.toolkit.utils.ws.VWUDDIBusinessImportDialog;
import filenet.vw.toolkit.utils.ws.VWUDDIProcessMonitorDialog;
import filenet.vw.toolkit.utils.ws.VWUDDIRegistryManager;
import filenet.vw.toolkit.utils.ws.base.IVWUDDIBusinessStatusListener;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessStatusEvent;
import filenet.vw.toolkit.utils.ws.base.VWUDDIEvent;
import filenet.vw.toolkit.utils.ws.base.VWUDDIRegistryItem;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSBusinessService;
import filenet.ws.api.uddi.WSTModel;
import filenet.ws.api.uddi.WSUDDIRegistry;
import filenet.ws.api.uddi.WSUDDIUtils;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.error.RegistryException;

public final class VWUDDIBrowsePanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener,
IVWToolbarBorderActionListener,
ItemSelectable,
MouseListener,
ChangeListener,
DocumentListener,
IVWUDDIBusinessStatusListener,
KeyListener {
    private static Robot robot = null;
    private Frame m_parentFrame = null;
    private VWUDDIRegistryManager m_uddiRegistryManager = null;
    private VWSession m_session = null;
    private boolean m_bFirstTime = true;
    private JSplitPane m_mainPanel = null;
    private JPanel m_browserPane = null;
    private JPanel m_blankPanel = new JPanel();
    private JScrollPane m_uddiRegistryPane = null;
    private JPanel m_uddiRegistryPanel = null;
    private VWUDDIBusinessDetailsPanel m_businessDetailsPanel = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private JScrollPane m_businessServicePane = null;
    private JPanel m_businessServicePanel = null;
    private JScrollPane m_tModelDetailsPane = null;
    private JPanel m_tModelDetailsPanel = null;
    private JTextField m_uddiRegistryNameUI = null;
    private JTextArea m_inquiryURLUI = null;
    private JTextArea m_publishURLUI = null;
    private BusinessQuery m_businessQueryObject = null;
    private SearchBusinessServices m_businessSearchObject = null;
    private JTextField m_businessServiceNameUI = null;
    private JTextArea m_businessServiceDescriptionUI = null;
    private JTextField m_tModelNameUI = null;
    private JTextField m_tModelAuthorizedName = null;
    private JTextArea m_tModelDescriptionUI = null;
    private JTextArea m_tModelOverviewDocDescriptionUI = null;
    private JTextArea m_tModelOverviewDocURLUI = null;
    private DefaultMutableTreeNode m_rootNode = null;
    private DefaultMutableTreeNode m_currentSelectedNode = null;
    private Object m_currentNodeInfo = null;
    private JTree m_tree = null;
    private DefaultTreeModel m_treeModel = null;
    private Hashtable m_objToNode = new Hashtable();
    private JPopupMenu m_popup = null;
    private JMenuItem m_logonMenuItem = null;
    private JMenuItem m_newBusinessMenuItem = null;
    private JMenuItem m_importMenuItem = null;
    private JMenuItem m_publishMenuItem = null;
    private JMenuItem m_refreshMenuItem = null;
    private JMenuItem m_deleteMenuItem = null;
    private Object m_popupUserObject = null;
    private VWUDDIRegistryItem m_currentRegistryItem = null;
    private ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
    protected ItemListener m_selectListeners = null;

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:56:28  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.16  $";
    }

    public VWUDDIBrowsePanel(Frame parent, VWSession session, VWUDDIRegistryManager uddiRegistryManager) {
        super(new BorderLayout(10, 10));
        this.m_parentFrame = parent;
        this.m_session = session;
        this.m_uddiRegistryManager = uddiRegistryManager;
        this.m_uddiRegistryManager.addChangeListener(this);
        this.initData(uddiRegistryManager);
        this.m_toolBarBorder = new VWToolbarBorder("", 0x10600000);
        this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x400000));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x200000));
        this.setupLayout();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setDividerLocation(0.3);
                this.m_mainPanel.setDividerSize(3);
            }
        }
    }

    public void businessChanged(VWUDDIBusinessStatusEvent evt) {
        int type = evt.getType();
        if (type == 1 || type == 3) {
            this.m_tree.updateUI();
        }
    }

    protected void initData(VWUDDIRegistryManager uddiRegistryManager) {
        VWUDDIRegistryItem[] uddiRegistryItemArray = null;
        if (uddiRegistryManager != null) {
            uddiRegistryItemArray = uddiRegistryManager.getUDDIRegistryItemList();
            this.m_businessQueryObject = new BusinessQuery();
            this.m_businessSearchObject = new SearchBusinessServices();
        }
        if (uddiRegistryItemArray == null) {
            uddiRegistryItemArray = new VWUDDIRegistryItem[]{};
        }
        this.m_rootNode = this.newTreeNode(uddiRegistryItemArray);
        if (uddiRegistryItemArray != null && uddiRegistryItemArray.length > 0) {
            DefaultMutableTreeNode registryNode = null;
            for (int i = 0; i < uddiRegistryItemArray.length; ++i) {
                if (uddiRegistryItemArray[i] == null) continue;
                registryNode = this.newTreeNode(uddiRegistryItemArray[i]);
                registryNode.setAllowsChildren(true);
                this.m_rootNode.add(registryNode);
                if (!uddiRegistryItemArray[i].isConnected()) continue;
                DefaultMutableTreeNode node = this.newTreeNode(this.m_businessQueryObject);
                registryNode.add(node);
            }
        } else {
            VWUDDIRegistry[] vwUDDIRegistryArray;
            VWUDDIRegistryList vwUDDIRegistryList = uddiRegistryManager.getUDDIRegistryList();
            if (vwUDDIRegistryList != null && (vwUDDIRegistryArray = vwUDDIRegistryList.getUDDIRegistries()) != null) {
                DefaultMutableTreeNode registryNode = null;
                int regListSz = vwUDDIRegistryArray.length;
                for (int i = 0; i < regListSz; ++i) {
                    if (!vwUDDIRegistryArray[i].getPublish()) continue;
                    VWUDDIRegistryItem vwUDDIRegItem = new VWUDDIRegistryItem(vwUDDIRegistryArray[i]);
                    vwUDDIRegItem.setState(0);
                    registryNode = this.newTreeNode(vwUDDIRegItem);
                    registryNode.setAllowsChildren(true);
                    this.m_rootNode.add(registryNode);
                }
            }
        }
        if (this.m_treeModel != null) {
            this.m_treeModel.setRoot(this.m_rootNode);
        }
    }

    protected void setupLayout() {
        this.setVisible(false);
        this.m_mainPanel = new JSplitPane(1, false);
        JScrollPane treeScrollPane = new JScrollPane(this.initTreePanel());
        this.m_browserPane = new JPanel();
        this.m_browserPane.setLayout(new BorderLayout(4, 4));
        this.m_browserPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_browserPane.add((Component)this.m_toolBarBorder, "Center");
        JPanel toolbarPanel = this.m_toolBarBorder.getClientPanel();
        toolbarPanel.setLayout(new BorderLayout());
        toolbarPanel.add((Component)treeScrollPane, "Center");
        if (this.compOrientation.isLeftToRight()) {
            this.m_mainPanel.setLeftComponent(this.m_browserPane);
            this.m_mainPanel.setRightComponent(this.m_blankPanel);
        } else {
            this.m_mainPanel.setLeftComponent(this.m_blankPanel);
            this.m_mainPanel.setRightComponent(this.m_browserPane);
        }
        this.m_mainPanel.setContinuousLayout(true);
        this.add((Component)this.m_mainPanel, "Center");
    }

    private void initUDDIRegistryPanel() {
        if (this.m_uddiRegistryPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_uddiRegistryPanel = new JPanel();
        this.m_uddiRegistryPane = new JScrollPane(this.m_uddiRegistryPanel);
        this.m_uddiRegistryPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_uddiBusinessRegistryDetails, 0);
        this.m_uddiRegistryPanel.add((Component)toolbarBorder, "First");
        VWAccessibilityHelper.setAccessibility(toolbarBorder, this, VWResource.s_uddiBusinessRegistryDetails, VWResource.s_uddiBusinessRegistryDetails);
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        VWAccessibilityHelper.setAccessibility(nameLabel, this, VWResource.s_name, VWResource.s_name);
        this.m_uddiRegistryNameUI = new JTextField();
        this.m_uddiRegistryNameUI.setEditable(false);
        this.m_uddiRegistryNameUI.setBorder(null);
        VWAccessibilityHelper.setAccessibility(this.m_uddiRegistryNameUI, this, VWResource.s_uddiRegistryNameTextField, VWResource.s_uddiRegistryNameTextField);
        VWAccessibilityHelper.setLabelFor(nameLabel, this.m_uddiRegistryNameUI);
        JLabel inquiryURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_inquiryURL));
        this.m_inquiryURLUI = new JTextArea();
        this.m_inquiryURLUI.setEditable(false);
        this.m_inquiryURLUI.setRows(1);
        this.m_inquiryURLUI.setColumns(20);
        this.m_inquiryURLUI.setLineWrap(true);
        this.m_inquiryURLUI.setWrapStyleWord(true);
        this.m_inquiryURLUI.setBackground(panel.getBackground());
        VWAccessibilityHelper.setAccessibility(inquiryURLLabel, this, VWResource.s_inquiryURL, VWResource.s_inquiryURL);
        VWAccessibilityHelper.setAccessibility(this.m_inquiryURLUI, this, VWResource.s_inquiryURL, VWResource.s_inquiryURL);
        VWAccessibilityHelper.setLabelFor(inquiryURLLabel, this.m_inquiryURLUI);
        JLabel publishURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_publishURL));
        this.m_publishURLUI = new JTextArea();
        this.m_publishURLUI.setEditable(false);
        this.m_inquiryURLUI.setRows(1);
        this.m_publishURLUI.setColumns(20);
        this.m_publishURLUI.setLineWrap(true);
        this.m_publishURLUI.setWrapStyleWord(true);
        this.m_publishURLUI.setBackground(panel.getBackground());
        VWAccessibilityHelper.setAccessibility(publishURLLabel, this, VWResource.s_publishURL, VWResource.s_publishURL);
        VWAccessibilityHelper.setAccessibility(this.m_publishURLUI, this, VWResource.s_publishURL, VWResource.s_publishURL);
        VWAccessibilityHelper.setLabelFor(publishURLLabel, this.m_publishURLUI);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_uddiRegistryNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)inquiryURLLabel, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_inquiryURLUI), c);
        c.gridy = 4;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)publishURLLabel, c);
        c.gridy = 5;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_publishURLUI), c);
    }

    private void updateUDDIRegistryPanel(VWUDDIRegistryItem uddiRegistry) {
        this.initUDDIRegistryPanel();
        if (this.m_uddiRegistryPane == null || uddiRegistry == null) {
            return;
        }
        if (this.m_uddiRegistryNameUI != null) {
            this.m_uddiRegistryNameUI.setText(uddiRegistry.getName());
        }
        if (this.m_inquiryURLUI != null) {
            this.m_inquiryURLUI.setText(uddiRegistry.getInquiryURL());
        }
        if (this.m_publishURLUI != null) {
            this.m_publishURLUI.setText(uddiRegistry.getPublishURL());
        }
    }

    private void initBusinessDetailsPanel(VWUDDIBusinessItem businessItem) {
        if (this.m_businessDetailsPanel == null) {
            this.m_businessDetailsPanel = new VWUDDIBusinessDetailsPanel(this.m_parentFrame, this.m_session, this.m_uddiRegistryManager, businessItem);
            this.m_businessDetailsPanel.addBusinessStatusListener(this);
        }
    }

    private void updateBusinessDetailsPanel(VWUDDIBusinessItem businessItem) {
        this.initBusinessDetailsPanel(businessItem);
        if (this.m_businessDetailsPanel != null) {
            this.m_businessDetailsPanel.updateBusinessDetailPanel(this.m_currentRegistryItem, businessItem);
        }
    }

    private void initBusinessServicePanel() {
        if (this.m_businessServicePane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_businessServicePanel = new JPanel();
        this.m_businessServicePane = new JScrollPane(this.m_businessServicePanel);
        this.m_businessServicePanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_businessServiceDetails, 0);
        this.m_businessServicePanel.add((Component)toolbarBorder, "First");
        VWAccessibilityHelper.setAccessibility(toolbarBorder, this, VWResource.s_businessServiceDetails, VWResource.s_businessServiceDetails);
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_businessServiceNameUI = new JTextField();
        this.m_businessServiceNameUI.setEditable(false);
        this.m_businessServiceNameUI.setBorder(null);
        VWAccessibilityHelper.setAccessibility(nameLabel, this, VWResource.s_name, VWResource.s_name);
        VWAccessibilityHelper.setAccessibility(this.m_businessServiceNameUI, this, VWResource.s_businessServiceName, VWResource.s_businessServiceName);
        VWAccessibilityHelper.setLabelFor(nameLabel, this.m_businessServiceNameUI);
        JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_description));
        this.m_businessServiceDescriptionUI = new JTextArea();
        this.m_businessServiceDescriptionUI.setEditable(false);
        this.m_businessServiceDescriptionUI.setRows(3);
        this.m_businessServiceDescriptionUI.setColumns(20);
        this.m_businessServiceDescriptionUI.setLineWrap(true);
        this.m_businessServiceDescriptionUI.setWrapStyleWord(true);
        this.m_businessServiceDescriptionUI.setBackground(panel.getBackground());
        VWAccessibilityHelper.setAccessibility(descriptionLabel, this, VWResource.s_description, VWResource.s_description);
        VWAccessibilityHelper.setAccessibility(this.m_businessServiceDescriptionUI, this, VWResource.s_businessDescription, VWResource.s_businessDescription);
        VWAccessibilityHelper.setLabelFor(descriptionLabel, this.m_businessServiceDescriptionUI);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_businessServiceNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)descriptionLabel, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_businessServiceDescriptionUI, c);
    }

    private void updateBusinessServiceDetailsPanel(WSBusinessService businessService) {
        this.initBusinessServicePanel();
        if (this.m_businessServicePane == null || businessService == null) {
            return;
        }
        if (this.m_businessServiceNameUI != null) {
            this.m_businessServiceNameUI.setText(businessService.getName());
        }
        if (this.m_businessServiceDescriptionUI != null) {
            this.m_businessServiceDescriptionUI.setText(businessService.getDescription());
        }
        this.m_businessServicePane.updateUI();
    }

    private void initTModelDetailsPanel() {
        if (this.m_tModelDetailsPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_tModelDetailsPanel = new JPanel();
        this.m_tModelDetailsPane = new JScrollPane(this.m_tModelDetailsPanel);
        this.m_tModelDetailsPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsdlTModelDetails, 0);
        VWAccessibilityHelper.setAccessibility(toolbarBorder, this, VWResource.s_wsdlTModelDetails, VWResource.s_wsdlTModelDetails);
        this.m_tModelDetailsPanel.add((Component)toolbarBorder, "First");
        JPanel panel = toolbarBorder.getClientPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_tModelNameUI = new JTextField();
        this.m_tModelNameUI.setEditable(false);
        this.m_tModelNameUI.setBorder(null);
        VWAccessibilityHelper.setAccessibility(nameLabel, this, VWResource.s_name, VWResource.s_name);
        VWAccessibilityHelper.setAccessibility(this.m_tModelNameUI, this, VWResource.s_wsdlTModelName, VWResource.s_wsdlTModelName);
        VWAccessibilityHelper.setLabelFor(nameLabel, this.m_tModelNameUI);
        JLabel authorizedNameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_authorizedName));
        this.m_tModelAuthorizedName = new JTextField();
        this.m_tModelAuthorizedName.setEditable(false);
        this.m_tModelAuthorizedName.setBorder(null);
        VWAccessibilityHelper.setAccessibility(authorizedNameLabel, this, VWResource.s_authorizedName, VWResource.s_authorizedName);
        VWAccessibilityHelper.setAccessibility(this.m_tModelAuthorizedName, this, VWResource.s_authorizedName, VWResource.s_authorizedName);
        VWAccessibilityHelper.setLabelFor(authorizedNameLabel, this.m_tModelAuthorizedName);
        JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_description));
        this.m_tModelDescriptionUI = new JTextArea();
        this.m_tModelDescriptionUI.setEditable(false);
        this.m_tModelDescriptionUI.setRows(3);
        this.m_tModelDescriptionUI.setColumns(20);
        this.m_tModelDescriptionUI.setLineWrap(true);
        this.m_tModelDescriptionUI.setWrapStyleWord(true);
        this.m_tModelDescriptionUI.setBackground(panel.getBackground());
        VWAccessibilityHelper.setAccessibility(descriptionLabel, this, VWResource.s_description, VWResource.s_description);
        VWAccessibilityHelper.setAccessibility(this.m_tModelDescriptionUI, this, VWResource.s_wsdlTModelDescription, VWResource.s_wsdlTModelDescription);
        VWAccessibilityHelper.setLabelFor(descriptionLabel, this.m_tModelDescriptionUI);
        JLabel overviewDocDescriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_overviewDocumentDescription));
        this.m_tModelOverviewDocDescriptionUI = new JTextArea();
        this.m_tModelOverviewDocDescriptionUI.setEditable(false);
        this.m_tModelOverviewDocDescriptionUI.setRows(2);
        this.m_tModelOverviewDocDescriptionUI.setColumns(20);
        this.m_tModelOverviewDocDescriptionUI.setLineWrap(true);
        this.m_tModelOverviewDocDescriptionUI.setWrapStyleWord(true);
        this.m_tModelOverviewDocDescriptionUI.setBackground(panel.getBackground());
        VWAccessibilityHelper.setAccessibility(overviewDocDescriptionLabel, this, VWResource.s_overviewDocumentDescription, VWResource.s_overviewDocumentDescription);
        VWAccessibilityHelper.setAccessibility(this.m_tModelOverviewDocDescriptionUI, this, VWResource.s_overviewDocumentDescription, VWResource.s_overviewDocumentDescription);
        VWAccessibilityHelper.setLabelFor(overviewDocDescriptionLabel, this.m_tModelOverviewDocDescriptionUI);
        JLabel overviewDocURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_overviewDocumentURL));
        this.m_tModelOverviewDocURLUI = new JTextArea();
        this.m_tModelOverviewDocURLUI.setEditable(false);
        this.m_tModelOverviewDocURLUI.setRows(2);
        this.m_tModelOverviewDocURLUI.setColumns(20);
        this.m_tModelOverviewDocURLUI.setLineWrap(true);
        this.m_tModelOverviewDocURLUI.setWrapStyleWord(true);
        this.m_tModelOverviewDocURLUI.setBackground(panel.getBackground());
        VWAccessibilityHelper.setAccessibility(overviewDocURLLabel, this, VWResource.s_overviewDocumentURL, VWResource.s_overviewDocumentURL);
        VWAccessibilityHelper.setAccessibility(this.m_tModelOverviewDocURLUI, this, VWResource.s_overviewDocumentURL, VWResource.s_overviewDocumentURL);
        VWAccessibilityHelper.setLabelFor(overviewDocURLLabel, this.m_tModelOverviewDocURLUI);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = 1;
        panel.add((Component)this.m_tModelNameUI, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)authorizedNameLabel, c);
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_tModelAuthorizedName, c);
        c.gridy = 4;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)descriptionLabel, c);
        c.gridy = 5;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_tModelDescriptionUI), c);
        c.gridy = 6;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)overviewDocDescriptionLabel, c);
        c.gridy = 7;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_tModelOverviewDocDescriptionUI), c);
        c.gridy = 8;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)overviewDocURLLabel, c);
        c.gridy = 9;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)new JScrollPane(this.m_tModelOverviewDocURLUI), c);
    }

    private void updateTModelDetailsPanel(WSTModel tModel) {
        this.initTModelDetailsPanel();
        if (this.m_tModelDetailsPane == null || tModel == null) {
            return;
        }
        if (this.m_tModelNameUI != null) {
            this.m_tModelNameUI.setText(tModel.getName());
        }
        if (this.m_tModelAuthorizedName != null) {
            this.m_tModelAuthorizedName.setText(tModel.getAuthorizedName());
        }
        if (this.m_tModelDescriptionUI != null) {
            this.m_tModelDescriptionUI.setText(tModel.getDescription());
        }
        if (this.m_tModelOverviewDocDescriptionUI != null) {
            this.m_tModelOverviewDocDescriptionUI.setText(tModel.getOverviewDocDescription());
        }
        if (this.m_tModelDescriptionUI != null) {
            this.m_tModelOverviewDocURLUI.setText(tModel.getOverviewDocURL());
        }
        this.m_tModelDetailsPane.updateUI();
    }

    private JPanel initBrowserPanel() {
        this.m_browserPane = new JPanel();
        this.m_browserPane.setLayout(new BorderLayout(4, 4));
        this.m_browserPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_browserPane.add((Component)this.m_toolBarBorder, "First");
        return this.m_browserPane;
    }

    private JPanel initTreePanel() {
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout(10, 10));
        this.m_tree = new JTree(this.m_rootNode);
        this.m_tree.setName("BrowseTree.VWUDDIBrowsePanel");
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.m_tree.setCellRenderer(new VWUDDIBrowseTreeCellRenderer());
        treePanel.add(this.m_tree);
        VWAccessibilityHelper.setAccessibility(this.m_tree, this, VWResource.s_uddiRegistryTree, VWResource.s_uddiRegistryTree);
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.addTreeWillExpandListener(this);
        this.m_tree.addMouseListener(this);
        this.m_tree.addKeyListener(this);
        TreeModel treeModel = this.m_tree.getModel();
        if (treeModel != null && treeModel instanceof DefaultTreeModel) {
            this.m_treeModel = (DefaultTreeModel)treeModel;
        }
        return treePanel;
    }

    private DefaultMutableTreeNode newTreeNode(Object obj) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
        this.m_objToNode.put(obj, node);
        return node;
    }

    private void setTreeNodeUserObject(DefaultMutableTreeNode node, Object obj) {
        if (node.getUserObject() != null) {
            if (this.m_objToNode.get(node.getUserObject()) != null) {
                this.m_objToNode.remove(node.getUserObject());
            }
            node.setUserObject(obj);
            this.m_objToNode.put(obj, node);
        }
    }

    private void removeAllChildren(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> enum1 = node.children();
        TreeNode obj = null;
        DefaultMutableTreeNode child = null;
        while (enum1.hasMoreElements()) {
            obj = enum1.nextElement();
            if (obj == null || !(obj instanceof DefaultMutableTreeNode)) continue;
            child = (DefaultMutableTreeNode)obj;
            this.removeAllChildren(child);
            node.removeAllChildren();
            this.m_objToNode.remove(child);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        Object userObject = null;
        if (this.m_currentSelectedNode == null) {
            return;
        }
        userObject = this.m_currentSelectedNode.getUserObject();
        if (userObject == null) {
            return;
        }
        try {
            switch (event.getID()) {
                case 0x400000: {
                    this.onRefresh();
                    break;
                }
                case 0x10000000: {
                    this.onDelete();
                    break;
                }
                case 0x200000: {
                    this.onPublish();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Object userObject = null;
        if (this.m_currentSelectedNode == null) {
            return;
        }
        userObject = this.m_currentSelectedNode.getUserObject();
        if (userObject == null) {
            return;
        }
        if (source == this.m_logonMenuItem) {
            this.onLogon(this.m_currentSelectedNode);
        }
        if (source == this.m_newBusinessMenuItem) {
            this.onNewBusiness(this.m_currentSelectedNode);
        }
        if (source == this.m_importMenuItem) {
            this.onImportBusiness(this.m_currentSelectedNode);
        } else if (source == this.m_publishMenuItem) {
            this.onPublish();
        } else if (source == this.m_refreshMenuItem) {
            this.onRefresh();
        } else if (source == this.m_deleteMenuItem && userObject != null) {
            this.onDelete();
        }
    }

    private void onNewBusiness(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        try {
            Object userObject = node.getUserObject();
            if (userObject instanceof VWUDDIRegistryItem) {
                VWUDDIRegistryItem registryItem = (VWUDDIRegistryItem)userObject;
                VWUDDIBusinessItem vwBusinessItem = registryItem.newBusiness(VWResource.s_newBusiness);
                vwBusinessItem.setModified(true);
                int childCount = node.getChildCount();
                if (childCount > 0) {
                    for (int i = childCount - 1; i >= 0; --i) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                        if (!(childNode.getUserObject() instanceof BusinessQuery)) continue;
                        node.remove(childNode);
                    }
                }
                DefaultMutableTreeNode businessNode = this.newTreeNode(vwBusinessItem);
                node.add(businessNode);
                TreePath[] treePath = this.m_tree.getSelectionPaths();
                if (treePath != null && treePath[0] != null && treePath[0].getLastPathComponent() == this.m_tree.getLastSelectedPathComponent()) {
                    this.m_tree.scrollPathToVisible(treePath[0]);
                    this.m_tree.expandPath(treePath[0]);
                }
                this.m_tree.updateUI();
            }
        }
        catch (Exception ex) {
            this.showMessage(VWResource.s_failedToCreateNewBusiness, VWResource.s_refresh, 1, ex);
            VWDebug.logException(ex);
        }
    }

    private void onImportBusiness(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        try {
            Object userObject = node.getUserObject();
            if (userObject instanceof VWUDDIRegistryItem) {
                VWUDDIRegistryItem registryItem = (VWUDDIRegistryItem)userObject;
                VWUDDIBusinessImportDialog importDialog = new VWUDDIBusinessImportDialog(this.m_parentFrame, registryItem);
                importDialog.setVisible(true);
                int retStatus = importDialog.getReturnStatus();
                if (retStatus != 0) {
                    return;
                }
                WSBusinessEntity wsBusinessEntity = importDialog.getWSBusinessEntity();
                if (wsBusinessEntity == null) {
                    return;
                }
                VWUDDIBusinessItem vwBusinessItem = new VWUDDIBusinessItem(wsBusinessEntity);
                vwBusinessItem.setModified(true);
                registryItem.setBusinessItem(vwBusinessItem);
                int childCount = node.getChildCount();
                if (childCount > 0) {
                    for (int i = childCount - 1; i >= 0; --i) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                        if (!(childNode.getUserObject() instanceof BusinessQuery)) continue;
                        node.remove(childNode);
                    }
                }
                DefaultMutableTreeNode businessNode = this.newTreeNode(vwBusinessItem);
                node.add(businessNode);
                TreePath[] treePath = this.m_tree.getSelectionPaths();
                if (treePath != null && treePath[0] != null && treePath[0].getLastPathComponent() == this.m_tree.getLastSelectedPathComponent()) {
                    this.m_tree.scrollPathToVisible(treePath[0]);
                    this.m_tree.expandPath(treePath[0]);
                }
                this.m_tree.updateUI();
            }
        }
        catch (Exception ex) {
            this.showMessage(VWResource.s_failedToCreateNewBusiness, VWResource.s_refresh, 1, ex);
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onDelete() {
        Cursor currentCursor;
        block37: {
            block38: {
                block36: {
                    boolean success;
                    int response;
                    DefaultMutableTreeNode businessNode;
                    DefaultMutableTreeNode registryNode;
                    VWUDDIBusinessItem businessItem;
                    VWUDDIRegistryItem registryItem;
                    Object userObject;
                    block35: {
                        if (this.m_currentSelectedNode == null) {
                            return;
                        }
                        Object object = userObject = this.m_currentSelectedNode.getUserObject();
                        registryItem = null;
                        businessItem = null;
                        WSBusinessService service = null;
                        WSTModel tModel = null;
                        TreeNode node = null;
                        DefaultMutableTreeNode treeNode = null;
                        registryNode = null;
                        businessNode = null;
                        DefaultMutableTreeNode serviceNode = null;
                        node = treeNode = this.m_currentSelectedNode;
                        currentCursor = null;
                        do {
                            if (object instanceof WSTModel) {
                                tModel = (WSTModel)object;
                                continue;
                            }
                            if (object instanceof WSBusinessService) {
                                service = (WSBusinessService)object;
                                serviceNode = treeNode;
                                continue;
                            }
                            if (object instanceof VWUDDIBusinessItem) {
                                businessItem = (VWUDDIBusinessItem)object;
                                businessNode = treeNode;
                                continue;
                            }
                            if (!(object instanceof VWUDDIRegistryItem)) continue;
                            registryItem = (VWUDDIRegistryItem)object;
                            registryNode = treeNode;
                            break;
                        } while ((node = node.getParent()) != null && node instanceof DefaultMutableTreeNode && (object = (treeNode = node).getUserObject()) != null);
                        if (registryItem == null) {
                            return;
                        }
                        if (tModel != null) {
                            return;
                        }
                        if (userObject instanceof WSBusinessService) {
                            if (this.m_uddiRegistryManager.authenticate(this.m_parentFrame, registryItem) != VWUDDIRegistryManager.UDDI_AUTHENTICATE_SUCCESS) {
                                return;
                            }
                            String serviceName = service.getName();
                            response = VWMessageDialog.showConfirmDialog(this.m_parentFrame, VWResource.s_deleteServiceWarning.toString(serviceName));
                            if (response != 1) {
                                return;
                            }
                            try {
                                Object var17_18;
                                try {
                                    success = registryItem.deleteBusinessService(service);
                                    if (!success) {
                                        this.showMessage(VWResource.s_failedToDeleteService.toString(serviceName), VWResource.s_deleteService, 1);
                                    } else {
                                        if (businessNode != null && serviceNode != null && this.m_treeModel != null) {
                                            businessNode.remove(serviceNode);
                                            this.m_treeModel.nodeStructureChanged(businessNode);
                                            this.m_tree.setSelectionPath(new TreePath(businessNode.getPath()));
                                        }
                                        JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_serviceDeleted.toString(serviceName), VWResource.s_deleteService, 1);
                                    }
                                }
                                catch (Exception ex) {
                                    if (currentCursor != null) {
                                        this.setCursor(currentCursor);
                                        currentCursor = null;
                                    }
                                    this.showMessage(VWResource.s_failedToDeleteService.toString(serviceName), VWResource.s_deleteService, 1, ex);
                                    var17_18 = null;
                                    if (currentCursor != null) {
                                        this.setCursor(currentCursor);
                                    }
                                    break block35;
                                }
                                var17_18 = null;
                                if (currentCursor == null) break block35;
                            }
                            catch (Throwable throwable) {
                                Object var17_19 = null;
                                if (currentCursor == null) throw throwable;
                                this.setCursor(currentCursor);
                                throw throwable;
                            }
                            this.setCursor(currentCursor);
                        }
                    }
                    if (!(userObject instanceof VWUDDIBusinessItem)) return;
                    String businessName = null;
                    if (businessItem.getName(0) != null) {
                        businessName = businessItem.getName(0).getValue();
                    }
                    if ((response = VWMessageDialog.showConfirmDialog(this.m_parentFrame, VWResource.s_deleteBusinessWarning.toString(businessName))) != 1) {
                        return;
                    }
                    try {
                        try {
                            boolean bSaveRegInfo;
                            if (this.m_uddiRegistryManager.authenticate(this.m_parentFrame, registryItem) != VWUDDIRegistryManager.UDDI_AUTHENTICATE_SUCCESS) {
                                Object var19_22 = null;
                                if (currentCursor == null) return;
                                break block36;
                            }
                            currentCursor = this.getCursor();
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            success = registryItem.deleteBusinessEntity(businessItem);
                            if (!success) {
                                this.showMessage(VWResource.s_failedToDeleteBusiness.toString(businessName), VWResource.s_deleteBusiness, 1);
                                break block37;
                            }
                            boolean bl = bSaveRegInfo = !((VWUDDIBusinessItem)userObject).isNewBusiness();
                            if (!bSaveRegInfo) {
                                this.m_uddiRegistryManager.deleteBusiness(registryItem, bSaveRegInfo);
                            } else {
                                if (this.m_uddiRegistryManager.authenticate(this.m_parentFrame, registryItem) != VWUDDIRegistryManager.UDDI_AUTHENTICATE_SUCCESS) {
                                    break block38;
                                }
                                VWUDDIProcessMonitorDialog publishMonitor = new VWUDDIProcessMonitorDialog(this.m_parentFrame, this.m_uddiRegistryManager, registryItem, 3, VWResource.s_deleteBusiness);
                                publishMonitor.setVisible(true);
                                publishMonitor.releaseResources();
                            }
                            if (businessNode != null && registryNode != null && this.m_treeModel != null) {
                                registryNode.remove(businessNode);
                                this.m_treeModel.nodeStructureChanged(registryNode);
                                this.m_tree.setSelectionPath(new TreePath(registryNode.getPath()));
                            }
                            if (!bSaveRegInfo) {
                                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_businessDeleted.toString(businessName), VWResource.s_deleteBusiness, 1);
                            }
                            break block37;
                        }
                        catch (Exception ex) {
                            if (currentCursor != null) {
                                this.setCursor(currentCursor);
                                currentCursor = null;
                            }
                            this.showMessage(VWResource.s_failedToDeleteBusiness.toString(businessName), VWResource.s_deleteBusiness, 1, ex);
                            Object var19_25 = null;
                            if (currentCursor == null) return;
                            this.setCursor(currentCursor);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var19_26 = null;
                        if (currentCursor == null) throw throwable;
                        this.setCursor(currentCursor);
                        throw throwable;
                    }
                }
                this.setCursor(currentCursor);
                return;
            }
            Object var19_23 = null;
            if (currentCursor == null) return;
            this.setCursor(currentCursor);
            return;
        }
        Object var19_24 = null;
        if (currentCursor == null) return;
        this.setCursor(currentCursor);
    }

    private void onLogon(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof VWUDDIRegistryItem) {
            VWUDDIRegistryItem registryItem = (VWUDDIRegistryItem)userObject;
            this.m_uddiRegistryManager.authenticate(this.m_parentFrame, registryItem);
            if (this.m_businessDetailsPanel != null) {
                this.m_businessDetailsPanel.setBusinessDisplayMode(registryItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onPublish() {
        try {
            try {
                if (!this.m_businessDetailsPanel.update()) return;
                Object userObject = this.m_currentSelectedNode.getUserObject();
                if (userObject == null) {
                    return;
                }
                if (!(userObject instanceof VWUDDIBusinessItem)) return;
                TreeNode node = this.m_currentSelectedNode.getParent();
                if (node != null && node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) != null && userObject instanceof VWUDDIRegistryItem) {
                    VWUDDIRegistryItem vwUDDIRegistryItem = (VWUDDIRegistryItem)userObject;
                    if (this.m_uddiRegistryManager.authenticate(this.m_parentFrame, vwUDDIRegistryItem) != VWUDDIRegistryManager.UDDI_AUTHENTICATE_SUCCESS) {
                        return;
                    }
                    VWUDDIBusinessItem businessItem = null;
                    VWUDDIProcessMonitorDialog publishMonitor = new VWUDDIProcessMonitorDialog(this.m_parentFrame, this.m_uddiRegistryManager, vwUDDIRegistryItem, 1, VWResource.s_publishBusiness);
                    publishMonitor.setVisible(true);
                    if (publishMonitor.getStatus() == 4) {
                        businessItem = publishMonitor.getBusinessItem();
                    }
                    publishMonitor.releaseResources();
                    if (businessItem != null) {
                        businessItem.setNewBusiness(false);
                        businessItem.setModified(false);
                        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x400000));
                    }
                }
                this.updateUI();
                return;
            }
            catch (Exception ex) {
                this.showMessage(VWResource.s_failedToPublish, VWResource.s_publish, 1, ex);
                VWDebug.logException(ex);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRefresh() {
        Cursor currentCursor;
        block22: {
            block20: {
                block21: {
                    String nodeName = "";
                    currentCursor = null;
                    try {
                        try {
                            Object userObject = this.m_currentSelectedNode.getUserObject();
                            if (userObject == null) {
                                Object var6_8 = null;
                                if (currentCursor == null) break block20;
                                break block21;
                            }
                            currentCursor = this.getCursor();
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            if (userObject instanceof VWUDDIRegistryItem) {
                                VWUDDIRegistryItem registryItem = (VWUDDIRegistryItem)userObject;
                                nodeName = registryItem.getName();
                                if (registryItem.getState() != 1) {
                                    registryItem.validateCert();
                                }
                                if (registryItem.isConnected()) {
                                    registryItem.refresh();
                                    this.executeBusinessQuery(this.m_currentSelectedNode);
                                }
                                break block22;
                            }
                            if (userObject instanceof VWUDDIBusinessItem) {
                                nodeName = ((VWUDDIBusinessItem)userObject).getName(0) != null ? ((VWUDDIBusinessItem)userObject).getName(0).getValue() : null;
                                this.refreshBusinessEntity(this.m_currentSelectedNode, (VWUDDIBusinessItem)userObject);
                                break block22;
                            }
                            if (userObject instanceof WSBusinessService) {
                                WSBusinessService wsBusinessService = (WSBusinessService)userObject;
                            }
                            break block22;
                        }
                        catch (UnknownHostException ex) {
                            this.showMessage(VWResource.s_refreshFailed.toString(nodeName), VWResource.s_refresh, 1, ex);
                            Object var6_10 = null;
                            if (currentCursor != null) {
                                this.setCursor(currentCursor);
                            }
                            this.updateUI();
                            return;
                        }
                        catch (ConnectException ex) {
                            this.showMessage(VWResource.s_refreshFailed.toString(nodeName), VWResource.s_refresh, 1, ex);
                            Object var6_11 = null;
                            if (currentCursor != null) {
                                this.setCursor(currentCursor);
                            }
                            this.updateUI();
                            return;
                        }
                        catch (SSLHandshakeException ex) {
                            this.showMessage(VWResource.s_refreshFailed.toString(nodeName), VWResource.s_refresh, 1, ex);
                            Object var6_12 = null;
                            if (currentCursor != null) {
                                this.setCursor(currentCursor);
                            }
                            this.updateUI();
                            return;
                        }
                        catch (Exception ex) {
                            this.showMessage(VWResource.s_refreshFailed.toString(nodeName), VWResource.s_refresh, 1, ex);
                            VWDebug.logException(ex);
                            Object var6_13 = null;
                            if (currentCursor != null) {
                                this.setCursor(currentCursor);
                            }
                            this.updateUI();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_14 = null;
                        if (currentCursor != null) {
                            this.setCursor(currentCursor);
                        }
                        this.updateUI();
                        throw throwable;
                    }
                }
                this.setCursor(currentCursor);
            }
            this.updateUI();
            return;
        }
        Object var6_9 = null;
        if (currentCursor != null) {
            this.setCursor(currentCursor);
        }
        this.updateUI();
    }

    private void refreshBusinessEntity(DefaultMutableTreeNode businessEntityNode, VWUDDIBusinessItem vwBusinessItem) throws Exception {
        TreeNode regNode;
        String nodeName = null;
        if (vwBusinessItem.getName(0) != null) {
            nodeName = vwBusinessItem.getName(0).getValue();
        }
        if ((regNode = businessEntityNode.getParent()) != null && regNode instanceof DefaultMutableTreeNode) {
            int retOpt = 1;
            if (vwBusinessItem.isModified()) {
                String businessName = null;
                if (vwBusinessItem.getName(0) != null) {
                    businessName = vwBusinessItem.getName(0).getValue();
                }
                retOpt = this.showOptionDialog(VWResource.s_refreshUDDIBusinessWarning.toString(businessName), VWResource.s_refresh, 3, 5);
            }
            if (retOpt == 1) {
                if (vwBusinessItem.hasBusinessKey()) {
                    vwBusinessItem.refresh();
                    Object parentObj = ((DefaultMutableTreeNode)regNode).getUserObject();
                    VWUDDIRegistryItem regItem = (VWUDDIRegistryItem)parentObj;
                    regItem.setNeedRefreshServices(true);
                    this.getBusinessServices(businessEntityNode);
                    regItem.setNeedRefreshServices(false);
                    this.updateBusinessDetailsPanel(vwBusinessItem);
                    vwBusinessItem.setModified(false);
                } else {
                    Object parentNodeUserObject = ((DefaultMutableTreeNode)regNode).getUserObject();
                    if (parentNodeUserObject != null && parentNodeUserObject instanceof VWUDDIRegistryItem) {
                        VWUDDIRegistryItem uddiRegistryItem = (VWUDDIRegistryItem)parentNodeUserObject;
                        String uddiName = uddiRegistryItem.getName();
                        String businessName = uddiRegistryItem.getBusinessName();
                        WSUDDIRegistry wsUDDIRegistry = uddiRegistryItem.getWSUDDIRegistry();
                        VWUDDIRegistryList vwUDDIRegistryList = new VWUDDIRegistryList(this.m_session);
                        VWUDDIRegistry vwUDDIRegistry = vwUDDIRegistryList.getUDDIRegistry(uddiName);
                        if (vwUDDIRegistry != null) {
                            VWUDDIBusinessEntity vwBusinessEntity = vwUDDIRegistry.getVWBusinessEntity(businessName);
                            if (vwBusinessEntity != null) {
                                BusinessEntity businessEntity = vwBusinessEntity.getBusinessEntity();
                                vwBusinessItem = new VWUDDIBusinessItem(wsUDDIRegistry, businessEntity);
                                this.setTreeNodeUserObject(businessEntityNode, vwBusinessItem);
                                this.updateBusinessDetailsPanel(vwBusinessItem);
                            } else {
                                this.showMessage(VWResource.s_refreshFailed.toString(nodeName), VWResource.s_refresh, 1);
                            }
                        } else {
                            this.showMessage(VWResource.s_refreshFailed.toString(nodeName), VWResource.s_refresh, 1);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeBusinessQuery(DefaultMutableTreeNode treeNode) {
        if (this.m_businessQueryObject == null) return;
        if (treeNode == null) return;
        Cursor currentCursor = null;
        try {
            block13: {
                try {
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    Object userObject = treeNode.getUserObject();
                    if (userObject == null || !(userObject instanceof VWUDDIRegistryItem)) break block13;
                    this.removeAllChildren(treeNode);
                    VWUDDIRegistryItem regItem = (VWUDDIRegistryItem)userObject;
                    VWUDDIBusinessItem vwBusinessItem = null;
                    try {
                        vwBusinessItem = this.m_businessQueryObject.findProcessBusiness(regItem);
                    }
                    catch (RegistryException ex) {
                        vwBusinessItem = regItem.createVWBusinessItem();
                        vwBusinessItem.setValid(false);
                        String errMsg = WSUDDIUtils.getErrMsg(ex);
                        if (!(errMsg != null && errMsg.length() > 0 || (errMsg = ex.getMessage()) != null && errMsg.length() > 0)) {
                            errMsg = ex.toString();
                        }
                        VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_failedToQueryForBusinesses + "\n" + errMsg, VWResource.s_error, 1);
                    }
                    if (vwBusinessItem == null) break block13;
                    DefaultMutableTreeNode businessNode = this.newTreeNode(vwBusinessItem);
                    treeNode.add(businessNode);
                    if (vwBusinessItem.isValid() && vwBusinessItem.hasBusinessKey()) {
                        businessNode.add(this.newTreeNode(this.m_businessSearchObject));
                    }
                }
                catch (Exception ex) {
                    String errMsg = ex.getLocalizedMessage();
                    if (!(errMsg != null && errMsg.length() > 0 || (errMsg = ex.getMessage()) != null && errMsg.length() > 0)) {
                        errMsg = ex.toString();
                    }
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_failedToQueryForBusinesses + "\n" + errMsg, VWResource.s_error, 1);
                    Object var9_12 = null;
                    if (this.m_treeModel != null && treeNode != null) {
                        this.m_treeModel.nodeStructureChanged(treeNode);
                    }
                    if (currentCursor == null) return;
                    this.setCursor(currentCursor);
                    return;
                }
            }
            Object var9_11 = null;
            if (this.m_treeModel != null && treeNode != null) {
                this.m_treeModel.nodeStructureChanged(treeNode);
            }
            if (currentCursor == null) return;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (this.m_treeModel != null && treeNode != null) {
                this.m_treeModel.nodeStructureChanged(treeNode);
            }
            if (currentCursor == null) throw throwable;
            this.setCursor(currentCursor);
            throw throwable;
        }
        this.setCursor(currentCursor);
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, listener);
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        return node;
    }

    public Object[] getSelectedObjects() {
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo != null) {
            Object[] objects = null;
            objects = new Object[]{nodeInfo};
            return objects;
        }
        return null;
    }

    protected void notifySelectListeners() {
        Object nodeInfo = this.getSelectedObject();
        String wsdlURL = null;
        if (nodeInfo != null && !(nodeInfo instanceof WSUDDIRegistry) && !(nodeInfo instanceof VWUDDIBusinessItem) && nodeInfo instanceof WSTModel) {
            wsdlURL = ((WSTModel)nodeInfo).getOverviewDocURL();
        }
        ItemEvent event = new ItemEvent(this, 0, wsdlURL, 1);
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object nodeInfo;
        try {
            if (this.m_currentNodeInfo != null && this.m_currentNodeInfo instanceof VWUDDIBusinessItem) {
                VWUDDIBusinessItem businessItem = (VWUDDIBusinessItem)this.m_currentNodeInfo;
                BusinessEntity uddiBusinessEntity = businessItem.getBusinessEntity();
                this.m_businessDetailsPanel.update();
            }
        }
        catch (Exception ex) {
            this.showMessage(VWResource.s_failedToChangeFocus, VWResource.s_error, 1, ex);
            return;
        }
        TreePath selPath = e.getPath();
        if (selPath == null) {
            return;
        }
        this.m_currentSelectedNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        this.m_currentNodeInfo = nodeInfo = this.getSelectedObject();
        JComponent newComponent = null;
        String accessibilityInfo = null;
        if (nodeInfo != null) {
            this.m_currentRegistryItem = null;
            TreeNode[] nodes = this.m_treeModel.getPathToRoot(this.getSelectedTreeNode());
            if (nodes != null && nodes.length > 0) {
                Object obj = null;
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i] == null || !(nodes[i] instanceof DefaultMutableTreeNode) || (obj = ((DefaultMutableTreeNode)nodes[i]).getUserObject()) == null || !(obj instanceof VWUDDIRegistryItem)) continue;
                    this.m_currentRegistryItem = (VWUDDIRegistryItem)obj;
                }
            }
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x400000));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x200000));
            if (nodeInfo instanceof VWUDDIRegistryItem[]) {
                newComponent = this.m_blankPanel;
                this.m_currentRegistryItem = null;
                accessibilityInfo = VWResource.s_uddiRegistries;
            } else if (nodeInfo instanceof VWUDDIRegistryItem) {
                VWUDDIRegistryItem regItem = (VWUDDIRegistryItem)nodeInfo;
                this.updateUDDIRegistryPanel(regItem);
                newComponent = this.m_uddiRegistryPane;
                if (regItem.getState() != 0) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x400000));
                }
                accessibilityInfo = regItem.getName();
            } else if (nodeInfo instanceof VWUDDIBusinessItem) {
                Name name;
                VWUDDIBusinessItem businessItem = (VWUDDIBusinessItem)nodeInfo;
                this.updateBusinessDetailsPanel(businessItem);
                newComponent = this.m_businessDetailsPanel;
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
                if (businessItem.isValid()) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x200000));
                    if (!businessItem.isNewBusiness()) {
                        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x400000));
                    }
                }
                if ((name = businessItem.getName(0)) != null) {
                    accessibilityInfo = name.getValue();
                }
            } else if (nodeInfo instanceof WSBusinessService) {
                this.updateBusinessServiceDetailsPanel((WSBusinessService)nodeInfo);
                newComponent = this.m_businessServicePane;
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x400000));
                accessibilityInfo = ((WSBusinessService)nodeInfo).getName();
            } else if (nodeInfo instanceof WSTModel) {
                this.updateTModelDetailsPanel((WSTModel)nodeInfo);
                newComponent = this.m_tModelDetailsPane;
                accessibilityInfo = ((WSTModel)nodeInfo).getName();
            }
            this.notifySelectListeners();
            if (newComponent != null) {
                int dividerLocation = this.m_mainPanel.getDividerLocation();
                if (this.compOrientation.isLeftToRight()) {
                    this.m_mainPanel.setRightComponent(newComponent);
                } else {
                    this.m_mainPanel.setLeftComponent(newComponent);
                }
                this.m_mainPanel.setDividerLocation(dividerLocation);
                this.m_mainPanel.setDividerSize(3);
            }
        }
        if (accessibilityInfo != null) {
            VWAccessibilityHelper.setAccessibility(this.m_tree, this, accessibilityInfo, accessibilityInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getBusinessServices(DefaultMutableTreeNode treeNode) {
        Object obj = null;
        obj = treeNode.getUserObject();
        if (obj == null) return;
        if (!(obj instanceof VWUDDIBusinessItem)) return;
        Cursor currentCursor = null;
        try {
            try {
                currentCursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.m_businessSearchObject.searchBusinessServices(treeNode);
            }
            catch (Exception ex) {
                Object var6_5 = null;
                if (currentCursor == null) return;
                this.setCursor(currentCursor);
                return;
            }
            Object var6_4 = null;
            if (currentCursor == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (currentCursor == null) throw throwable;
            this.setCursor(currentCursor);
            throw throwable;
        }
        this.setCursor(currentCursor);
    }

    private void deleteService(VWUDDIRegistryItem registry, WSBusinessService service) {
        if (registry == null) {
            return;
        }
        try {
            boolean success = registry.deleteBusinessService(service);
            if (!success) {
                this.showMessage(VWResource.s_failedToDeleteService.toString(service.getName()), VWResource.s_error, 1);
            }
        }
        catch (Exception ex) {
            this.showMessage(VWResource.s_failedToDeleteService.toString(service.getName()), VWResource.s_error, 1, ex);
        }
    }

    private void deleteBusiness(VWUDDIRegistryItem registry, VWUDDIBusinessItem businessItem) {
        if (registry == null || businessItem == null) {
            return;
        }
        this.m_uddiRegistryManager.authenticate(this.m_parentFrame, registry);
        try {
            boolean success = registry.deleteBusinessEntity(businessItem);
            if (!success) {
                String name = null;
                if (businessItem.getName(0) != null) {
                    name = businessItem.getName(0).getValue();
                }
                this.showMessage(VWResource.s_failedToDeleteBusiness.toString(name), VWResource.s_deleteBusiness, 1);
            }
        }
        catch (Exception ex) {
            String name = null;
            if (businessItem.getName(0) != null) {
                name = businessItem.getName(0).getValue();
            }
            this.showMessage(VWResource.s_failedToDeleteBusiness.toString(name), VWResource.s_deleteBusiness, 1, ex);
        }
    }

    private int showMessage(String msg, String title, int msgType) {
        return this.showMessage(msg, title, msgType, null);
    }

    private int showMessage(String msg, String title, int msgType, Exception ex) {
        int retStatus = 0;
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        retStatus = VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, title, msgType);
        return retStatus;
    }

    private int showOptionDialog(String msg, String title, int msgType, int optionType) {
        int retStatus = VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, title, msgType, optionType, null, null, 0, 0);
        return retStatus;
    }

    private void showPopup(MouseEvent event) {
        Object userObject;
        Object obj;
        TreePath path;
        Object source = event.getSource();
        Point point = event.getPoint();
        if (source == this.m_tree && (path = this.m_tree.getPathForLocation(point.x, point.y)) != null && (obj = path.getLastPathComponent()) != null && obj instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)obj).getUserObject()) != null && (userObject instanceof VWUDDIBusinessItem || userObject instanceof VWUDDIRegistryItem || userObject instanceof WSBusinessService)) {
            this.m_popupUserObject = userObject;
            this.createPopup(this, event);
        }
    }

    private void createPopup(Container container, int x, int y) {
        if (this.m_popup == null) {
            this.m_popup = new JPopupMenu();
        } else {
            this.m_popup.removeAll();
        }
        if (this.m_logonMenuItem == null) {
            this.m_logonMenuItem = new JMenuItem(VWResource.s_logon);
            this.m_logonMenuItem.addActionListener(this);
        }
        if (this.m_newBusinessMenuItem == null) {
            this.m_newBusinessMenuItem = new JMenuItem(VWResource.s_new);
            this.m_newBusinessMenuItem.addActionListener(this);
        }
        if (this.m_importMenuItem == null) {
            this.m_importMenuItem = new JMenuItem(VWResource.s_import);
            this.m_importMenuItem.addActionListener(this);
        }
        if (this.m_refreshMenuItem == null) {
            this.m_refreshMenuItem = new JMenuItem(VWResource.s_refresh);
            this.m_refreshMenuItem.addActionListener(this);
        }
        if (this.m_publishMenuItem == null) {
            this.m_publishMenuItem = new JMenuItem(VWResource.s_publish);
            this.m_publishMenuItem.addActionListener(this);
        }
        if (this.m_deleteMenuItem == null) {
            this.m_deleteMenuItem = new JMenuItem(VWResource.s_delete);
            this.m_deleteMenuItem.addActionListener(this);
        }
        if (this.m_popupUserObject != null) {
            if (this.m_popupUserObject instanceof VWUDDIRegistryItem) {
                VWUDDIRegistryItem regItem = (VWUDDIRegistryItem)this.m_popupUserObject;
                if (regItem.isConnected()) {
                    String businessName;
                    if (!regItem.isAuthenticated()) {
                        this.m_popup.add(this.m_logonMenuItem);
                    }
                    if ((businessName = regItem.getBusinessName()) == null || businessName.length() <= 0) {
                        this.m_popup.add(this.m_newBusinessMenuItem);
                        this.m_popup.add(this.m_importMenuItem);
                    }
                }
                if (regItem.getState() != 0) {
                    this.m_popup.add(this.m_refreshMenuItem);
                }
            }
            if (this.m_popupUserObject instanceof VWUDDIBusinessItem) {
                VWUDDIBusinessItem businessItem = (VWUDDIBusinessItem)this.m_popupUserObject;
                if (businessItem.isValid()) {
                    if (!businessItem.isNewBusiness()) {
                        this.m_popup.add(this.m_refreshMenuItem);
                    }
                    this.m_popup.add(this.m_publishMenuItem);
                }
                this.m_popup.add(this.m_deleteMenuItem);
            }
            if (this.m_popupUserObject instanceof WSBusinessService) {
                this.m_popup.add(this.m_refreshMenuItem);
                this.m_popup.add(this.m_deleteMenuItem);
            }
        }
        this.m_popup.show(container, x, y);
    }

    private void createPopup(Container container, MouseEvent evt) {
        Point point = evt.getPoint();
        this.createPopup(this, point.x, point.y);
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        try {
            TreeNode childNode;
            DefaultMutableTreeNode treeNode;
            TreePath treePath = event.getPath();
            Object obj = treePath.getLastPathComponent();
            if (obj != null && obj instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)obj).getChildCount() == 1 && (childNode = treeNode.getChildAt(0)) != null && childNode instanceof DefaultMutableTreeNode) {
                Object userObject = treeNode.getUserObject();
                Object childUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                if (userObject != null && childUserObject != null) {
                    if (userObject instanceof VWUDDIBusinessItem && childUserObject instanceof SearchBusinessServices) {
                        this.getBusinessServices(treeNode);
                    } else if (userObject instanceof VWUDDIRegistryItem && childUserObject instanceof BusinessQuery) {
                        this.executeBusinessQuery(treeNode);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        } else {
            int selRow = this.m_tree.getRowForLocation(event.getX(), event.getY());
            this.m_tree.setSelectionRow(selRow);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 121: {
                TreePath path;
                int modifiers = event.getModifiers();
                if ((modifiers & 1) == 0 || (path = this.m_tree.getSelectionPath()) == null) break;
                int row = this.m_tree.getRowForPath(path);
                Rectangle rect = this.m_tree.getRowBounds(row);
                robot.keyPress(27);
                robot.keyRelease(27);
                if (this.m_currentSelectedNode != null) {
                    this.m_popupUserObject = this.m_currentSelectedNode.getUserObject();
                }
                if (rect == null) break;
                this.createPopup(this, rect.x + 2 * rect.width / 3, rect.y + 2 * rect.height / 3);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object obj;
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        if (source instanceof VWUDDIEvent) {
            VWUDDIEvent uddiEvent = (VWUDDIEvent)source;
            Object obj2 = uddiEvent.getSource();
            int type = uddiEvent.getEventType();
            if (obj2 != null && obj2 instanceof VWUDDIRegistryItem) {
                TreeNode aRegNode;
                VWUDDIRegistryItem regItem = (VWUDDIRegistryItem)uddiEvent.getSource();
                if (type == 5 && (aRegNode = this.findRegistryNode(this.m_rootNode, regItem)) != null) {
                    DefaultMutableTreeNode registryNode = (DefaultMutableTreeNode)aRegNode;
                    this.setTreeNodeUserObject(registryNode, regItem);
                    registryNode.setAllowsChildren(true);
                    if (regItem.isConnected()) {
                        DefaultMutableTreeNode node = this.newTreeNode(this.m_businessQueryObject);
                        registryNode.add(node);
                    }
                    this.validate();
                    this.updateUI();
                }
            }
        } else if (source instanceof VWUDDIRegistryItem && (obj = this.m_objToNode.get(source)) != null && obj instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
            if (treeNode.isLeaf()) {
                this.executeBusinessQuery(treeNode);
            } else {
                obj = treeNode.getFirstChild();
                if (obj != null && obj instanceof DefaultMutableTreeNode) {
                    this.getBusinessServices((DefaultMutableTreeNode)obj);
                }
            }
        }
    }

    public void insertUpdate(DocumentEvent event) {
    }

    public void removeUpdate(DocumentEvent event) {
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public boolean hasUnpublishedData() {
        String msg = this.checkUnPublishedData(this.m_rootNode);
        return msg != null && msg.length() > 0;
    }

    public boolean onClosePanel() {
        int ret;
        String msg = this.checkUnPublishedData(this.m_rootNode);
        return msg == null || msg.length() <= 0 || (ret = this.showOptionDialog(VWResource.s_closePublishDialogWarning + "\n\n" + msg, VWResource.s_publish, 3, 5)) != 4;
    }

    private String checkUnPublishedData(DefaultMutableTreeNode node) {
        String retMsg = "";
        Object userObject = node.getUserObject();
        if (userObject instanceof VWUDDIBusinessItem) {
            VWUDDIBusinessItem businessItem = (VWUDDIBusinessItem)userObject;
            if (businessItem.isModified()) {
                if (businessItem.getName(0) != null) {
                    retMsg = businessItem.getName(0).getValue();
                }
                retMsg = retMsg + "\n";
            }
        } else if (userObject instanceof VWUDDIRegistryItem[] || userObject instanceof VWUDDIRegistryItem) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                retMsg = retMsg + this.checkUnPublishedData((DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
        return retMsg;
    }

    private TreeNode findRegistryNode(TreeNode node, VWUDDIRegistryItem vwUDDIRegistryItem) {
        TreeNode aNode = null;
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            VWUDDIRegistryItem regItem;
            String regName;
            TreeNode childNode = node.getChildAt(i);
            Object userObject = ((DefaultMutableTreeNode)childNode).getUserObject();
            if (!(userObject instanceof VWUDDIRegistryItem) || (regName = vwUDDIRegistryItem.getName()).compareTo((regItem = (VWUDDIRegistryItem)userObject).getName()) != 0) continue;
            aNode = childNode;
            break;
        }
        return aNode;
    }

    static {
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    class SearchBusinessServices {
        public void searchBusinessServices(DefaultMutableTreeNode treeNode) {
            if (treeNode == null) {
                return;
            }
            try {
                Object obj = treeNode.getUserObject();
                if (obj != null && obj instanceof VWUDDIBusinessItem) {
                    VWUDDIBusinessItem businessItem = (VWUDDIBusinessItem)obj;
                    if (businessItem == null || !businessItem.hasBusinessKey()) {
                        return;
                    }
                    treeNode.removeAllChildren();
                    VWUDDIRegistryItem registryItem = null;
                    TreeNode parent = treeNode.getParent();
                    if (parent != null && parent instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)parent).getUserObject()) != null && obj instanceof VWUDDIRegistryItem) {
                        registryItem = (VWUDDIRegistryItem)obj;
                    }
                    if (registryItem == null || businessItem == null) {
                        return;
                    }
                    WSBusinessService[] services = registryItem.getBusinessServices(businessItem);
                    if (services != null && services.length > 0) {
                        for (int i = 0; i < services.length; ++i) {
                            if (services[i] == null) continue;
                            DefaultMutableTreeNode serviceNode = VWUDDIBrowsePanel.this.newTreeNode(services[i]);
                            treeNode.add(serviceNode);
                            WSTModel[] tModels = registryItem.getTModels(services[i]);
                            if (tModels == null || tModels.length <= 0) continue;
                            for (int j = 0; j < tModels.length; ++j) {
                                if (tModels[j] == null) continue;
                                DefaultMutableTreeNode node = VWUDDIBrowsePanel.this.newTreeNode(tModels[j]);
                                serviceNode.add(node);
                            }
                        }
                    }
                }
                if (VWUDDIBrowsePanel.this.m_treeModel != null) {
                    VWUDDIBrowsePanel.this.m_treeModel.nodeStructureChanged(treeNode);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex, "VWUDDIBrowsePanel::searchBusinessServices(DefaultMutableTreeNode treeNode)");
            }
        }
    }

    class BusinessQuery {
        public String toString() {
            return new String(VWResource.s_businessList);
        }

        public VWUDDIBusinessItem findProcessBusiness(VWUDDIRegistryItem uddiRegistry) throws Exception {
            if (uddiRegistry != null) {
                return uddiRegistry.getVWBusinessItem();
            }
            return null;
        }
    }
}

